#pragma once

#include <saas/rtyserver/indexer_core/normalizer.h>

class TRTYFullArchiveConfig;

class TArchiveLayersNormalizer : public NRTYServer::INormalizer {
public:
    TArchiveLayersNormalizer(const TRTYServerConfig& config, const TRTYFullArchiveConfig& componentConfig);

    virtual const char* Name() const;
    virtual bool AllRight(const NRTYServer::TNormalizerContext& context, const THolder<TFileMap>& indexFrq) const;
    virtual void Fix(const NRTYServer::TNormalizerContext& context, const THolder<TFileMap>& indexFrq) const;

private:
    void RestoreExternal(const NRTYServer::TNormalizerContext& context) const;
    void RestoreInternal(const NRTYServer::TNormalizerContext& context) const;
    void RemoveOldLayers(const NRTYServer::TNormalizerContext& context, const TSet<TString>& layers) const;
    NRTYServer::TBuilderCloseContext GetCloseContext(const NRTYServer::TNormalizerContext& context, ui32 docCount) const;
    TSet<TString> GetMissingLayers(const NRTYServer::TNormalizerContext& context) const;
    TSet<TString> GetPresentLayers(const NRTYServer::TNormalizerContext& context) const;

private:
    const TRTYFullArchiveConfig& ComponentConfig;

    mutable TVector<ui32> RemapTable;
};
