#pragma once

#include <saas/rtyserver/components/generator/parsed_entity.h>
#include <saas/rtyserver/model/component.h>

#include <util/memory/blob.h>
#include <util/generic/maybe.h>

class TRTYFullArchiveLightEntity: public TParsedDocument::TParsedEntity {
public:
    TRTYFullArchiveLightEntity(IParsedEntity::TConstructParams& params);

    void MergeToProto(NRTYServer::TParsedDoc& pd, const NRTYServer::TDocSerializeContext& context) const override;
    bool FillFromProto(const NRTYServer::TParsedDoc& pd, const NRTYServer::TDocParseContext& context) override;

    void SetData(TBlob&& data);
    const TBlob& GetData() const;

protected:
    void DoApplyPatch(const TParsedDocument& doc) override;

private:
    TBlob Data;
};
