#pragma once

#include <library/cpp/object_factory/object_factory.h>
#include <util/generic/fwd.h>
#include <util/generic/set.h>

#include <algorithm>

class TLightLayersRegistry {
public:
    static const TSet<TString>& GetRegisteredComponents() {
        return Instance()->GetComponents();
    }

    static TLightLayersRegistry* Instance() {
        return Singleton<TLightLayersRegistry>();
    }

    void Register(TStringBuf key) {
        Y_VERIFY(!ComponentNames.contains(key));

        ComponentNames.insert(TString{key});
    }

    bool IsLightLayer(TStringBuf key) const {
        return ComponentNames.contains(key);
    }

    const TSet<TString>& GetComponents() const {
        return ComponentNames;
    }

    class TRegistrator {
    public:
        TRegistrator(TStringBuf key) {
            Instance()->Register(key);
        }
    };

private:
    TSet<TString> ComponentNames;
};
