#pragma once

#include "globals.h"

#include <saas/protos/rtyserver.pb.h>
#include <saas/rtyserver/indexer_core/abstract_model.h>
#include <saas/rtyserver/components/generator/manager.h>

#include <util/generic/maybe.h>

struct TFAExtraSearchParams;

class IFAManager
    : public TBaseGeneratorManager
    , public IGetterDDKManager
{
public:
    IFAManager(const TRTYServerConfig& config);

    virtual ~IFAManager() {}
    virtual TParsedDocument::TPtr GetDoc(ui32 docId, NRTYServer::TMessage::TMessageType command = NRTYServer::TMessage::ADD_DOCUMENT, bool unsafe = false) const = 0;
    virtual TBlob ReadRawDoc(const TString& layer, ui32 docId) const = 0;
    virtual void Index(const TParsedDocument& document, const ui32 docId) = 0;
    virtual ERTYSearchResult DoSearch(const TRTYSearchRequestContext& context, ICustomReportBuilder& reportBuilder, const IIndexController& controller) const override;
    virtual void Remap(const TVector<ui32>* remapTable) = 0;
    virtual bool IsSearching() const override {
        return SupportsSearch;
    }

    virtual i64 PrnValue(ui32 /*docId*/, i64 defaultValue) const override {
        return defaultValue;
    }

    virtual const IDDKManager& GetDDKManager() const override;
    void SearchDocuments(const TVector<TDocIdCandidate>& docIds, const TCgiParameters& cgi, TVector<NMetaProtocol::TDocument>& documents, const TString& groupingAttr = "",  TVector<TString>* categs = nullptr) const;
    virtual bool SearchDocument(ui32 docId, const TCgiParameters& cgi, NMetaProtocol::TDocument& doc, const TFAExtraSearchParams* extraParams = nullptr) const = 0;
    virtual bool SearchDocumentCandidate(TDocIdCandidate docId, const TCgiParameters& cgi, NMetaProtocol::TDocument& doc, const TFAExtraSearchParams* extraParams = nullptr) const = 0;

protected:
    using TBaseGeneratorManager::GetDocInfo;
    bool GetDocInfo(const TString& layer, const NRTYServer::TParsedDoc& pd, NJson::TJsonValue& result) const;
    void CopyDocumentToReport(ui32 docId, const NRTYServer::TMessage::TDocument* src, const TCgiParameters& cgi, NMetaProtocol::TDocument& doc, const TFAExtraSearchParams* extraParams = nullptr) const;

private:
    const THolder<IDDKManager> DDKManager;
    const bool SupportsSearch;
};
