#pragma once

#include "manager.h"

#include <saas/rtyserver/indexer_core/parsed_document.h>
#include <saas/rtyserver/indexer_core/abstract_model.h>

#include <util/generic/hash.h>
#include <util/generic/vector.h>
#include <util/system/spinlock.h>

struct TRTYServerConfig;

class TMemoryFAManager: public IFAManager {
private:
    struct TRecord {
        TAdaptiveLock Lock;
        TParsedDocument::TPtr Doc;
        THashMap<TString, TBlob> LightEntities;
        void Swap(TRecord& other);
    };
    TVector<TRecord> Storage;

public:
    TMemoryFAManager(const TRTYServerConfig& config);

    virtual ui32 DoRemoveDocids(const TVector<ui32>& docids) override;
    virtual bool IsRemoved(ui32 docid) const override;
    virtual void Remap(const TVector<ui32>* remapTable) override;
    virtual ui32 GetDocumentsCountImpl() const override;
    virtual TParsedDocument::TPtr GetDoc(ui32 docId, NRTYServer::TMessage::TMessageType command = NRTYServer::TMessage::ADD_DOCUMENT, bool unsafe = false) const override final;
    virtual TBlob ReadRawDoc(const TString& layer, ui32 docId) const override;
    virtual void Index(const TParsedDocument& document, const ui32 docId) override;
    virtual bool GetDocInfo(const ui32 docId, NJson::TJsonValue& result) const override;
    virtual bool UpdateDoc(ui32 docId, const TParsedDocument::TPtr doc) override;

    virtual bool SearchDocument(ui32 docId, const TCgiParameters& cgi, NMetaProtocol::TDocument& doc, const TFAExtraSearchParams* extraParams) const override final;
    virtual bool SearchDocumentCandidate(TDocIdCandidate docId, const TCgiParameters& cgi, NMetaProtocol::TDocument& doc, const TFAExtraSearchParams* extraParams) const override final;
};
