#pragma once

#include <saas/rtyserver/indexer_core/normalizer.h>

#include <util/folder/path.h>

namespace NRTYServer {
    namespace NFullArchive {
        void NormalizeNames(const TFsPath& directory);
    }
}

class TArchiveNamesNormalizer: public NRTYServer::INormalizer {
public:
    TArchiveNamesNormalizer(const TRTYServerConfig& config)
        : NRTYServer::INormalizer(config)
    {
    }

    virtual const char* Name() const;
    virtual bool AllRight(const NRTYServer::TNormalizerContext& context, const THolder<TFileMap>& indexFrq) const;
    virtual void Fix(const NRTYServer::TNormalizerContext& context, const THolder<TFileMap>& indexFrq) const;
};
