#pragma once

#include <saas/rtyserver/components/generator/parsed_entity.h>

class TRTYFullArchiveParsedEntity: public TBaseGeneratorParsedEntity {
public:
    TRTYFullArchiveParsedEntity(TConstructParams& params);

    virtual void MergeToProto(NRTYServer::TParsedDoc& pd, const NRTYServer::TDocSerializeContext& context) const;
    virtual bool FillFromProto(const NRTYServer::TParsedDoc& pd, const NRTYServer::TDocParseContext& context);

    void SetDocument(const NRTYServer::TMessage::TDocument&);
    const NRTYServer::TMessage::TDocument& GetDocument() const;

protected:
    virtual void DoApplyPatch(const TParsedDocument& doc);
private:
    NRTYServer::TMessage::TDocument Document;
};

class TRTYFullArchiveComponentParser : public TBaseGeneratorEntityParser {
public:
    virtual void Parse(TParsingContext& context) const;
};
