#pragma once

#include <saas/rtyserver/config/searcher_config.h>
#include <saas/rtyserver/indexer_core/abstract_model.h>
#include <search/config/virthost.h>

namespace NRTYServer {
    class IExternalSearchCreator;
    enum class EUrlIdSource;
}

class TBaseIndexComponent: public NRTYServer::IIndexComponent {
public:
    TBaseIndexComponent(const TRTYServerConfig& config, bool isUsesd);
    ~TBaseIndexComponent();

    bool CheckConfig() const override;
    bool DoCheckMeta(const NRTYServer::TIndexMetadata& metaData) const override;
    bool DoMergeMeta(const NRTYServer::TMergeContext& context) const override;

    void CorrectSearchConfig(TSearchConfig& config, NRTYServer::TSearcherConfig::TSearchConfigType type) override;
    bool TuneSearch(TBaseCommonSearch* search, IRemapperUrlDocId& remapper, TRTYIndexData* data) const override;

    TPriorityInfo GetPriority() const override;
    const TIndexFiles& GetIndexFiles() const override;

    virtual bool HasIndexFiles(const TString& path) const;
    virtual bool IsEmptyIndex(const TString& path) const;
    virtual bool IsFinalIndex(const TString& path) const;

    THolder<TPruningConfig::ICalcer> CreatePruningCalcer(const NRTYServer::IIndexManagersStorage* managers) const override;

    NRTYServer::EUrlIdSource GetUrlIdSource() const;

protected:
    void ClearIndexFiles();
    void RegisterIndexFile(const TIndexFile& file);
    TIndexFile GetIndexFile(const TIndexFileEntry& entry, TIndexFile::EPrefetchPolicy policy, bool checked = false);

    template <typename TIndexFilesIterable>
    void RegisterIndexFilesList(const TIndexFilesIterable& indexFiles, TIndexFile::EPrefetchPolicy policy) {
        for (auto&& entry : indexFiles) {
            auto file = GetIndexFile(entry, policy);
            RegisterIndexFile(file);
        }
    }
protected:
    const TRTYServerConfig& Config;
    THolder<NRTYServer::IExternalSearchCreator> ExternalSearchCreator;

private:
    TIndexFiles IndexFiles;
};
