#include "index.h"

#include <kernel/keyinv/indexfile/searchfile.h>
#include <library/cpp/logger/global/global.h>
#include <util/system/fs.h>
THolder<TYndex4Searching> NRTYServer::GetYndex(const TFsPath& directory, const TString& prefix) try {
    auto result = MakeHolder<TYndex4Searching>();
    result->InitSearch(directory / prefix);
    return result;
} catch (...) {
    ERROR_LOG << "Cannot initialize Yndex4Searching: " << CurrentExceptionMessage() << Endl;
    return nullptr;
}

bool NRTYServer::HasTextWad(const TFsPath& directory, const TString& prefix) {
    return NFs::Exists(directory / (prefix + "keyinv.wad"));
}

bool NRTYServer::HasYndex(const TFsPath& directory, const TString& prefix) {
    return NFs::Exists(directory / (prefix + "key")) || NFs::Exists(directory / (prefix + "inv"));
}

bool NRTYServer::HasJupiPrep(const TFsPath& directory, const TString& /*prefix*/) {
    return NFs::Exists(directory / "jupi_prep_index");
}
