#pragma once

#include <kernel/keyinv/indexfile/searchfile.h>

#include <util/generic/ptr.h>
#include <util/generic/string.h>

class TFsPath;
class TYndex4Searching;

namespace NRTYServer {
    const TString DefaultIndexPrefix = "index";

    THolder<TYndex4Searching> GetYndex(const TFsPath& directory, const TString& prefix = DefaultIndexPrefix);
    bool HasYndex(const TFsPath& directory, const TString& prefix = DefaultIndexPrefix);
    bool HasTextWad(const TFsPath& directory, const TString& prefix = DefaultIndexPrefix);
    bool HasJupiPrep(const TFsPath& directory, const TString& prefix = DefaultIndexPrefix);
}
