#pragma once

#include <library/cpp/json/writer/json_value.h>

#include <util/folder/path.h>
#include <util/generic/map.h>

class TKpsInfo {
public:
    inline void Add(i64 kps, i64 value = 1) {
        Kps[kps] += value;
    }

    bool Load(const TString& indexDir);
    void Save(const TString& indexDir);

    NJson::TJsonValue GenerateJson() const;

private:
    TFsPath GetFilePath(const TString& indexDir);

private:
    TMap<i64, i64> Kps;
};
