#include "kpsinfo_normalizer.h"
#include "kpsinfo.h"

#include <saas/rtyserver/config/config.h>

TKpsInfoNormalizer::TKpsInfoNormalizer(const TRTYServerConfig& config)
    : NRTYServer::INormalizer(config)
{
}

const char* TKpsInfoNormalizer::Name() const {
    return "kpsinfo";
}

bool TKpsInfoNormalizer::AllRight(const NRTYServer::TNormalizerContext& context, const THolder<TFileMap>&) const {
    if (Config.IsPrefixedIndex) {
        TKpsInfo info;
        return info.Load(context.Dir.PathName());
    } else {
        return true;
    }
}

void TKpsInfoNormalizer::Fix(const NRTYServer::TNormalizerContext& context, const THolder<TFileMap>&) const {
    if (Config.IsPrefixedIndex) {
        TKpsInfo kpsInfo;
        for (auto iterator = context.Managers.GetDocSearchInfoIterator(); iterator && iterator->IsValid(); iterator->Next()) {
            if (iterator->IsDeleted()) {
                continue;
            }
            kpsInfo.Add(iterator->Get().GetKeyPrefix());
        }
        kpsInfo.Save(context.Dir.PathName());
    }
}
