#pragma once

#include <saas/rtyserver/indexer_core/parsed_document.h>
#include <saas/rtyserver/indexer_core/document_parser.h>

class TBaseGeneratorParsedEntity : public TParsedDocument::TParsedEntity {
public:
    TBaseGeneratorParsedEntity(TConstructParams& params)
        : TParsedEntity(params)
        , IndexedDocIsGenerated(false)
    {
    }

    const NRealTime::TIndexedDoc* GetIndexedDoc() const {
        return IndexedDoc.Get();
    }

    NRealTime::TIndexedDoc* MutableIndexedDoc() const {
        return IndexedDoc.Get();
    }

    void SetIndexedDoc(TAtomicSharedPtr<NRealTime::TIndexedDoc> indexedDoc, bool generated = true) const {
        VERIFY_WITH_LOG(!IndexedDoc, "Incorrect SetIndexedDoc usage");
        IndexedDoc = indexedDoc;
        IndexedDocIsGenerated = generated;
    }

protected:
    mutable TAtomicSharedPtr<NRealTime::TIndexedDoc> IndexedDoc;
    mutable bool IndexedDocIsGenerated;
};

class TBaseGeneratorEntityParser : public TComponentParser {
public:
    virtual void Parse(TParsingContext& context) const;

protected:
    void ParseBody(TParsingContext& context) const;
    void ParseKeyPrefix(TParsingContext& context) const;
    void ParseUpdate(TParsingContext& context) const;
};
