#pragma once

#include <saas/rtyserver/components/generator/component.h>

namespace NRTYServer {
    struct TGenericGeneratorComponent final : TBaseIndexComponent {
        explicit TGenericGeneratorComponent(const TRTYServerConfig& config);

        TString GetName() const override;

        THolder<IIndexComponentBuilder> CreateBuilder(const TBuilderConstructionContext&) const override;
        THolder<IIndexComponentManager> CreateManager(const TManagerConstructionContext&) const override;
        IComponentParser::TPtr BuildParser() const override;
        IParsedEntity::TPtr BuildParsedEntity(IParsedEntity::TConstructParams&) const override;

        bool DoAllRight(const TNormalizerContext&) const override;
        void CheckAndFix(const TNormalizerContext&) const override;
        bool CheckAlways() const override;

        bool HasIndexFiles(const TString& path) const override;
        bool IsFinalIndex(const TString& path) const override;
        bool IsEmptyIndex(const TString& path) const override;

        bool DoMerge(const TMergeContext&) const override;
    };
}
