#include "manager.h"

#include <saas/rtyserver/config/const.h>

namespace NRTYServer {
    TGenericGeneratorManager::TGenericGeneratorManager(const TManagerConstructionContext& context, const TString& componentName)
        : TBaseIndexManager(context, componentName)
    {
        CheckFrqBordersForRemoveFlag = false;
    }

    void TGenericGeneratorManager::InitInteractions(const IIndexManagersStorage& storage) {
        FullArc = storage.GetManager<TBaseGeneratorManager>(FULL_ARCHIVE_COMPONENT_NAME);
        CHECK_WITH_LOG(FullArc);
    }

    ui32 TGenericGeneratorManager::GetDeletedDocumentsCount() const {
        return FullArc->GetDeletedDocumentsCount();
    }

    ui32 TGenericGeneratorManager::GetDocumentsCountImpl() const {
        return FullArc->IsOpened() ? FullArc->GetDocumentsCount() : 0;
    }

    bool TGenericGeneratorManager::IsRemoved(ui32 docid) const {
        return FullArc->IsRemoved(docid);
    }

    i64 TGenericGeneratorManager::PrnValue(ui32 /*docid*/, i64 defaultValue) const {
        return defaultValue;
    }

    bool TGenericGeneratorManager::UpdateDoc(ui32 /*docId*/, const TParsedDocument::TPtr) {
        return false;
    }
}
