#pragma once

#include <saas/rtyserver/components/generator/manager.h>

namespace NRTYServer {
    struct TGenericGeneratorManager : TBaseIndexManager {
        TGenericGeneratorManager(const NRTYServer::TManagerConstructionContext&, const TString& componentName);

        void InitInteractions(const IIndexManagersStorage& storage) final;

        ui32 GetDeletedDocumentsCount() const final;
        ui32 GetDocumentsCountImpl() const final;
        bool IsRemoved(ui32 docid) const final;
        i64  PrnValue(ui32 docid, i64 defaultValue) const final;

        bool UpdateDoc(ui32 docId, const TParsedDocument::TPtr doc) final;

    private:
        const TBaseGeneratorManager* FullArc = nullptr;
    };
}
