#pragma once
#include <util/stream/output.h>
#include <util/generic/hash.h>
#include <util/generic/hash_set.h>
#include <util/generic/maybe.h>

namespace NRTYServer {

    class TAllowedFingerprintMappings {
    private:
        THashMap<TString, THashSet<TString>> Data;
        TMaybe<TString> ParseErrorString;
    public:
        TAllowedFingerprintMappings() {}
        ~TAllowedFingerprintMappings() {}

        bool IsCompitable(TStringBuf queryFingerPrint, TStringBuf baseFingerPrint) const;
        void ParseFromConfigStr(TStringBuf in);
        void DoToString(IOutputStream& so) const;

        TMaybe<TString> GetParseErrorString() const {
            return ParseErrorString;
        }
    };

}
