#pragma once

#include <saas/rtyserver/model/builder.h>

#include <util/generic/ptr.h>

struct TRTYServerConfig;
class TRTYFullArchiveBuilder;

class IDocSearchInfoIterator;

namespace NSaasHnsw {
    struct IHnswStorage;
    struct IHnswStorageWriter;
}

namespace NRTYServer {
    class THnswComponentConfig;

    class THnswIndexFakeBuilder: public IIndexComponentBuilder {
    public:
        THnswIndexFakeBuilder(const TString& componentName);

        bool Start() override;
        bool Stop() override;
        NRTYServer::IIndexComponentManager* GetManager() override;
        bool DoClose(const TBuilderCloseContext&) override;
        void DoDiscard() override;
        void Index(int /*threadID*/, const TParsedDocument& /*document*/, const ui32 /*docId*/) override {}
        void InitInteractions(const IIndexBuildersStorage&) override {};
    };
}
