#include "config.h"

#include <library/cpp/yconf/conf.h>

#include <util/folder/path.h>

namespace NRTYServer {
    bool THnswComponentConfig::DoCheck() const {
        if (auto ssError = SearchSizeChooser.GetParseErrorString()) {
            ERROR_LOG << "Failed to parse HNSW/SearchSizeChooser: " << *ssError << Endl;
            return false;
        }
        return true;
    }

    void THnswComponentConfig::DoInit(const TYandexConfig::Section& componentSection) {
        IndexPath = componentSection.GetDirectives().Value("IndexPath", TString());
        MaxAllowedSearchSize = componentSection.GetDirectives().Value("MaxAllowedSearchSize", MaxAllowedSearchSize);
        MaxAllowedTopSize = componentSection.GetDirectives().Value("MaxAllowedTopSize", MaxAllowedTopSize);
        IgnoreFingerPrints = componentSection.GetDirectives().Value("IgnoreFingerPrints", IgnoreFingerPrints);
        LockDocumentIndexFat = componentSection.GetDirectives().Value("LockDocumentIndexFat", LockDocumentIndexFat);
        DirectModeForKvData = componentSection.GetDirectives().Value("DirectModeForKvData", DirectModeForKvData);
        SearchSizeChooser.ParseFromConfigStr(componentSection.GetDirectives().Value("SearchSizeChooser", TString{}));
        ResultDistanceClampInterval.ParseFromConfigStr(componentSection.GetDirectives().Value("ResultDistanceClampInterval", TString{}));
        AllowedFingerprintMappings.ParseFromConfigStr(componentSection.GetDirectives().Value("AllowedFingerprintMappings", TString{}));
        SegmentSearchersThreadsNum = componentSection.GetDirectives().Value("SegmentSearchersThreadsNum", SegmentSearchersThreadsNum);
        SegmentSearchersQueueLimit = componentSection.GetDirectives().Value("SegmentSearchersQueueLimit", SegmentSearchersQueueLimit);
    }

    void THnswComponentConfig::DoToString(IOutputStream& so) const {
        so << "IndexPath: " << IndexPath << Endl;
        so << "MaxAllowedSearchSize: " << MaxAllowedSearchSize << Endl;
        so << "MaxAllowedTopSize: " << MaxAllowedTopSize << Endl;
        so << "MaxAllowedTopSize: " << IgnoreFingerPrints << Endl;
        so << "LockDocumentIndexFat: " << LockDocumentIndexFat << Endl;
        so << "DirectModeForKvData: " << DirectModeForKvData << Endl;
        so << "SegmentSearchersThreadsNum: " << SegmentSearchersThreadsNum << Endl;
        so << "SegmentSearchersQueueLimit: " << SegmentSearchersQueueLimit << Endl;

        {
            so << "SearchSizeChooser: ";
            SearchSizeChooser.DoToString(so);
            so << Endl;
        }
        {
            so << "ResultDistanceClampInterval: ";
            ResultDistanceClampInterval.DoToString(so);
            so << Endl;
        }
        {
            so << "AllowedFingerprintMappings: ";
            AllowedFingerprintMappings.DoToString(so);
            so << Endl;
        }
    }
}
