#pragma once

#include "interval_value.h"
#include "search_size_chooser.h"
#include "allowed_fp_mappings.h"
#include <saas/library/daemon_base/module/module.h>
#include <saas/rtyserver/config/config.h>


namespace NRTYServer {
    extern const TString HnswComponentName;

    class THnswComponentConfig: public TPluginConfig<TRTYServerConfig::IComponentConfig> {
    protected:
        bool DoCheck() const override;
        void DoInit(const TYandexConfig::Section& componentSection) override;
        void DoToString(IOutputStream& so) const override;
    public:
        TString IndexPath;
        size_t MaxAllowedSearchSize = 1000;
        size_t MaxAllowedTopSize = 1000;
        bool IgnoreFingerPrints = false;
        bool LockDocumentIndexFat = true;
        bool DirectModeForKvData = false;
        bool TryUseLockedMapingsForAllFiles = true;
        size_t SegmentSearchersThreadsNum = 1;
        size_t SegmentSearchersQueueLimit = 3;
        THnswSearchSizeChooser SearchSizeChooser;
        TIntervalValue ResultDistanceClampInterval;
        TAllowedFingerprintMappings AllowedFingerprintMappings;
    };
}
