#include "interval_value.h"

#include <util/generic/vector.h>
#include <util/string/split.h>

namespace {
static constexpr char SegmentBeginChar = '[';
static constexpr char SegmentEndChar = ']';
static constexpr char DelimiterInSegment = ';';
}

namespace NRTYServer {


void TIntervalValue::ParseFromConfigStr(TStringBuf in) {
    try {
        if (in.empty()) {
            return;
        }
        Y_ENSURE(in.size() >= 5);
        Y_ENSURE(in.front() == SegmentBeginChar);
        Y_ENSURE(in.back() == SegmentEndChar);
        in.Skip(1);
        in.Chop(1);
        Split(in, ';', Min, Max);
        Inited = true;
    } catch (yexception& e) {
        ParseErrorString = e.what();
    }

}

void TIntervalValue::DoToString(IOutputStream& so) const {
    so << SegmentBeginChar << Min << DelimiterInSegment << Max << SegmentEndChar;
}


}
