#pragma once
#include <util/stream/output.h>
#include <util/generic/maybe.h>

namespace NRTYServer {

    class TIntervalValue {
    private:
        TMaybe<TString> ParseErrorString;
        bool Inited = false;
        float Min = 0;
        float Max = 0;
    public:
        TIntervalValue() {}
        ~TIntervalValue() {}

        float Clamp(float val) const {
            Y_ENSURE(!ParseErrorString, "TIntervalValue bad config: " << *ParseErrorString);
            if (!Inited) {
                return val;
            }
            return ClampVal(val, Min, Max);
        }

        void ParseFromConfigStr(TStringBuf in);
        void DoToString(IOutputStream& so) const;
        TMaybe<TString> GetParseErrorString() const {
            return ParseErrorString;
        }
    };

}
