#include "signals.h"
#include <util/generic/xrange.h>
#include <util/string/cast.h>

namespace {
constexpr TStringBuf DotProductsNumSignalName = "hnsw-component-dot-products-num";
constexpr TStringBuf ClampedResultsValuesNumSignalName = "hnsw-component-clamped-results-num";
constexpr TStringBuf InSegmentsQueueSumWaitTimeSignalName = "hnsw-component-in-segments-queue-wait-microseconds";

const TVector<double> DotProductsHistogram = {
    0, 100, 500, 1000,
    1500, 2000, 2500, 3000, 3500, 4000, 4500, 5000,
    6000, 7000, 8000, 9000, 10000,
    15000, 20000, 30000, 40000, 50000
};


const TVector<double> ClampedResultsValuesNumHistogram = {
    0, 1, 2, 4, 5, 6, 7, 8, 9,
    10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20,
    30, 40, 50, 60, 70, 80, 100
};

const TVector<double> InSegmentsQueueSumWaitTimeSignalNameHistogram = xrange(0, 1200, 10);

}

NRTYServer::THnswComponentSearchSignals::THnswComponentSearchSignals() {
    Init(TUnistat::Instance());
}

void NRTYServer::THnswComponentSearchSignals::Init(TUnistat & t) const {
    t.DrillHistogramHole(
        ToString(DotProductsNumSignalName), "dhhh", NUnistat::TPriority(1), DotProductsHistogram);
    t.DrillHistogramHole(
        ToString(ClampedResultsValuesNumSignalName), "dhhh", NUnistat::TPriority(1), ClampedResultsValuesNumHistogram);
    t.DrillHistogramHole(
        ToString(InSegmentsQueueSumWaitTimeSignalName), "dhhh", NUnistat::TPriority(1), InSegmentsQueueSumWaitTimeSignalNameHistogram);
}

void NRTYServer::THnswComponentSearchSignals::PushSearchStats(const THnswComponentSearchStats& stats) const {
    TUnistat& I = TUnistat::Instance();
    PushSignal(I, DotProductsNumSignalName, stats.UsedDotProductsNum);
    PushSignal(I, ClampedResultsValuesNumSignalName, stats.ClampedValsNum);
    PushSignal(I, InSegmentsQueueSumWaitTimeSignalName, stats.InSegmentsQueueSumWaitTime.MicroSeconds());
}
