#pragma once

#include <kernel/groupattrs/creator/metacreator.h>
#include <saas/rtyserver/components/search/sentence_lengths/writer.h>

#include <util/folder/path.h>
#include <util/system/mutex.h>

struct TDirConf;
class ITextArchiveBuilder;

namespace NRTYServer {
    struct TBuilderCloseContext;
}

struct TExternalIndexers {
    NGroupingAttrs::IMetaInfoCreator* MetaInfoCreator = nullptr;
    ISentenceLengthsWriter* SentenceLengthsWriter = nullptr;
    ITextArchiveBuilder* TextArchiveWriter = nullptr;
};

class TRTYMetaInfoCreator: public NGroupingAttrs::TMetainfoCreator {
private:
    TMutex Mutex;
public:
    void SaveC2NImpl(const TString& prefix) const;
    virtual void LoadC2N(const NGroupingAttrs::TConfig& /*config*/, const TString& /*prefix*/);
    virtual void SaveC2N(const TString& /*prefix*/) const;
    virtual TCateg AddCateg(const char* attrname, const char* categname);
};
