#pragma once

#include "index_manager.h"
#include <saas/rtyserver/indexer_core/normalizer.h>

class TGroupAttrsNormalizer: public NRTYServer::INormalizer {
public:
    TGroupAttrsNormalizer(const TRTYServerConfig& config);
    virtual const char* Name() const;
    virtual bool AllRight(const NRTYServer::TNormalizerContext& context, const THolder<TFileMap>& indexFrq) const;
    virtual void Fix(const NRTYServer::TNormalizerContext& context, const THolder<TFileMap>& indexFrq) const;
private:
    void MergeConfigs(const NRTYServer::TNormalizerContext& context, NGroupingAttrs::TConfig& mergedConfig) const;
    void MergeData(const NRTYServer::TNormalizerContext& context, const THolder<TFileMap>& indexFrq, NGroupingAttrs::TConfig& mergedConfig) const;
    void SwapFiles(const NRTYServer::TNormalizerContext& context) const;
};
