#pragma once

#include "index_parsed_entity.h"

#include <saas/rtyserver/components/generator/builder.h>
#include <saas/rtyserver/common/common_rty.h>
#include <saas/rtyserver/config/fwd.h>
#include <saas/rtyserver/indexer_core/abstract_model.h>

#include <kernel/indexer/baseproc/baseconf.h>
#include <kernel/indexer/direct_text/dt.h>
#include <kernel/tarc/dirconf/dirconf.h>
#include <kernel/tarc/merge/builder.h>

class TRTYIndexer;
class TRTYMetaInfoCreator;
class TRTYSentenceLengthWriter;


class TRTYIndexBuilder: public TBaseIndexBuilder {
private:
    TVector<THolder<TRTYIndexer>> BaseIndexers;
    const NRTYServer::TIndexerConfig& Config;
    const TBaseConfig& BaseConfig;
    const TDirConf& DirConfig;
    THolder<TRTYMetaInfoCreator> MetaInfoCreator;
    THolder<TRTYSentenceLengthWriter> SentenceLengthsWriter;
    THolder<ITextArchiveBuilder> TextArchiveWriter;

public:
    TRTYIndexBuilder(const NRTYServer::TIndexerConfig& config,
                     const TDirConf& dirConfig,
                     const TBaseConfig& baseConfig, const TString& componentName);
    bool IsClosed() { return BaseIndexers.empty(); }

public: // NRTYServer::IIndexComponentBuilder
    ~TRTYIndexBuilder() override;
    void RegisterStoragesAttr(TVector<IYndexStorage*> storages) override;
    void RegisterStoragesLemm(TVector<IYndexStorage*> storages) override;
    void RegisterInvCreator(TVector<NIndexerCore::IDirectTextCallback4*> callbacks) override;
    void RegisterDTCallback(TVector<NIndexerCore::IDirectTextCallback2*> callbacks) override;
    void Index(int threadID, const TParsedDocument& document, const ui32 docId) override;
    bool DoClose(const NRTYServer::TBuilderCloseContext& context) override;
    bool Start() override;
    bool Stop() override;
};
