#pragma once

#include <saas/rtyserver/config/const.h>
#include <saas/rtyserver/indexer_core/abstract_model.h>
#include <saas/rtyserver/indexer_core/normalizer.h>
#include <saas/rtyserver/components/generator/component.h>

class TRTYIndexComponentConfig;

class TRTYIndexComponent: public TBaseIndexComponent {
public:
    TRTYIndexComponent(const TRTYServerConfig& config);
    bool DoMerge(const NRTYServer::TMergeContext& context) const override;
    TString GetName() const override { return INDEX_COMPONENT_NAME; }
    THolder<NRTYServer::IIndexComponentBuilder> CreateBuilder(const NRTYServer::TBuilderConstructionContext& context) const override;
    THolder<NRTYServer::IIndexComponentManager> CreateManager(const NRTYServer::TManagerConstructionContext& context) const override;
    bool DoAllRight(const NRTYServer::TNormalizerContext& context) const override;
    void CheckAndFix(const NRTYServer::TNormalizerContext& context) const override;
    bool GetInfoChecker(NRTYServer::TInfoChecker& info) const override;
    bool CheckConfig() const override;

    NRTYServer::IComponentParser::TPtr BuildParser() const override;
    NRTYServer::IParsedEntity::TPtr BuildParsedEntity(NRTYServer::IParsedEntity::TConstructParams& params) const override;

private:
    NRTYServer::TNormalizersCollection Normalizers;
    const TRTYIndexComponentConfig& IndexConfig;

    static TFactory::TRegistrator<TRTYIndexComponent> Registrator;
};
