#include "index_config.h"

#include <library/cpp/yconf/conf.h>

bool TRTYIndexComponentConfig::DoCheck() const {
    return true;
}

void TRTYIndexComponentConfig::DoInit(const TYandexConfig::Section& componentSection) {
    const auto& directives = componentSection.GetDirectives();
    WriteSentLens = directives.Value("WriteSentLens", true);
    ExcludeProperties = directives.Value("ExcludeProperties", false);
}

void TRTYIndexComponentConfig::DoToString(IOutputStream& so) const {
    so << "WriteSentLens : " << WriteSentLens << Endl;
    so << "ExcludeProperties : " << ExcludeProperties << Endl;
}
