#pragma once

#include "index_parsed_entity.h"

#include <saas/rtyserver/components/generator/manager.h>
#include <saas/rtyserver/indexer_core/abstract_model.h>

#include <ysite/yandex/common/ylens.h>

class TRTYIndexManager: public TBaseIndexManager {
public:
    bool UpdateDoc(ui32 docId, const TParsedDocument::TPtr doc) override;
    i64 PrnValue(ui32 /*docid*/, i64 /*defaultValue*/) const override {
        FAIL_LOG("Not implemented");
    }
    ui32 GetDocLen(ui32 docid) const override;
    void LinkIndexData(IRemapperUrlDocId& remapper, TRTYIndexData* indexData) const override;
    void UnlinkIndexData() const override;

public:
    TRTYIndexManager(const NRTYServer::TManagerConstructionContext& context, const TString& componentName);

private:
    mutable THolder<TDocsLens> DocsLens;
};
