#pragma once

#include <saas/rtyserver/indexer_core/parsed_document.h>
#include <saas/rtyserver/indexer_core/document_parser.h>
#include <saas/rtyserver/components/generator/parsed_entity.h>
#include <saas/library/attributes/attributes.h>

#include <kernel/tarc/iface/fulldoc.h>

class TIndexParsedEntity : public TBaseGeneratorParsedEntity {
public:
    TIndexParsedEntity(TConstructParams& params);

    NRTYServer::TAttrs& MutableSearchAttributes() {
        return SearchAttrs;
    }

    const NRTYServer::TAttrs& GetSearchAttributes() const {
        return SearchAttrs;
    }

    NRTYServer::TAttrs& MutableGroupingAttributes() {
        return GroupAttrs;
    }

    const NRTYServer::TAttrs& GetGroupingAttributes() const {
        return GroupAttrs;
    }

    NRTYServer::TAttrs& MutableDocumentProperties() {
        return DocProperties;
    }

    const NRTYServer::TAttrs& GetDocumentProperties() const {
        return DocProperties;
    }

    TDocInfoEx& MutableDocInfo() {
        return DocInfoEx;
    }

    const TDocInfoEx& GetDocInfo() const {
        return DocInfoEx;
    }

    TFullDocAttrs& MutableExtAttrs() const {
        return *ExtAttrs;
    }

    const TFullDocAttrs& GetExtAttrs() const {
        return *ExtAttrs;
    }

    void ResetExtAttrs();

    const TString& GetCustomParserConfig() const {
        return CustomParserConfig;
    }

    void SetCustomParserConfig(const TStringBuf& config) {
        CustomParserConfig = config;
    }

    void CopyDocInfo(const TDocInfoEx& docInfo);

    void SetBody(const TString& text);

    const TString& GetBody() const {
        return Body;
    }

    bool GetCheckXml() const {
        return CheckXml;
    }
    void SetCheckXml(bool check) {
        CheckXml = check;
    }

    void SetDocSearchInfo(const TDocSearchInfo& docInfo) override;
    void SetDocId(ui32 docid) override;
    void MergeToProto(NRTYServer::TParsedDoc& pd, const NRTYServer::TDocSerializeContext& context) const override;
    bool FillFromProto(const NRTYServer::TParsedDoc& pd, const NRTYServer::TDocParseContext& context) override;
    bool GetGroupAttrValue(const TString& name, i64& result) const override;

protected:
    void DoApplyPatch(const TParsedDocument& doc) override;

private:
    NRTYServer::TAttrs SearchAttrs;
    NRTYServer::TAttrs GroupAttrs;
    NRTYServer::TAttrs DocProperties;
    TDocInfoEx DocInfoEx;
    mutable THolder<TFullDocAttrs> ExtAttrs;
    TString CustomParserConfig;
    TFullArchiveDocHeader ArchiveDocHeader;
    TString Body;
    bool CheckXml;
    bool ExcludeProperties;
};

class TIndexComponentParser : public TBaseGeneratorEntityParser {
public:
    virtual void Parse(TParsingContext& context) const;

private:
    void ParseIndexedDoc(TParsingContext& context) const;
    void ParseSearchAttributes(TParsingContext& context) const;
    void ParseGroupAttributes(TParsingContext& context) const;
    void ParseProperties(TParsingContext& context) const;
    void ParseBody(TParsingContext& context) const;
    void ParseDocInfo(TParsingContext& context) const;
    void SetDefaultEncodingAndLanguages(TParsingContext& context) const;

    inline TString FilterAttrValue(const TString& value) const;
};
