#pragma once

#include <saas/rtyserver/config/zone_extractor_config.h>

#include <ysite/parser/xml/xml_yndx_transform.h>

#include <kernel/indexer/parseddoc/pdstorage.h>
#include <kernel/indexer/baseproc/baseconf.h>
#include <kernel/indexer/faceproc/docattrs.h>

#include <library/cpp/html/storage/storage.h>

class TRTYParsedDocStorage : public NIndexerCore::TParsedDocStorage {
public:
    TRTYParsedDocStorage(const TBaseConfig& cfg, const TZoneExtractorConfig& zoneExtCfg, bool backwardCompatible = false);
    void SetCustomConfig(const char* conf);
    void SetDocsAttrs(TFullDocAttrs& docsAttrs);
private:
    virtual void DoParseUnknownFormat(IParsedDocProperties* docProps, const TDocInfoEx* docInfo) override;
    virtual void DoNumerateUnknownFormat(MimeTypes mimeType, INumeratorHandler& handler, IParsedDocProperties* docProps) override;
    virtual void OnAfterParseDoc(IParsedDocProperties* docProps, const TDocInfoEx* docInfo) override;
private:
    const TZoneExtractorConfig& ZoneExtCfg;
    NXmlParser::TXmlConfigurator DefaultXmlConf;
    NXmlParser::TXmlConfigurator CustomXmlConf;
    NXmlParser::TXmlConfigurator* CurrentXmlConf;
    TFullDocAttrs* DocsAttrs;
    bool BackwardCompatibleTokenization;
};
