#include "pruning_normalizer.h"

TPruningNormalizer::TPruningNormalizer(const TRTYServerConfig& config)
: NRTYServer::INormalizer(config)
{}

const char* TPruningNormalizer::Name() const {
    return "pruning files";
}

bool TPruningNormalizer::AllRight(const NRTYServer::TNormalizerContext& context, const THolder<TFileMap>& /*indexFrq*/) const {
    const TFsPath prn = TFsPath(context.Dir.PathName()) / "indexprn";
    const TFsPath grp = TFsPath(context.Dir.PathName()) / "indexgrp";
    return !prn.Exists() && !grp.Exists();
}

void TPruningNormalizer::Fix(const NRTYServer::TNormalizerContext& context, const THolder<TFileMap>& /*indexFrq*/) const {
    const TFsPath prn = TFsPath(context.Dir.PathName()) / "indexprn";
    const TFsPath grp = TFsPath(context.Dir.PathName()) / "indexgrp";
    prn.DeleteIfExists();
    grp.DeleteIfExists();
}
