#pragma once

#include "ext_indexer.h"
#include "index_parsed_entity.h"

#include <saas/rtyserver/components/indexer/indexer/parsed_doc_storage.h>
#include <saas/rtyserver/indexer_core/guarded_document.h>
#include <saas/rtyserver/config/fwd.h>

#include <yweb/protos/indexeddoc.pb.h>

#include <kernel/tarc/dirconf/dirconf.h>
#include <kernel/indexer/attrproc/attrconf.h>
#include <kernel/docindexer/idstorage.h>

#include <kernel/keyinv/indexfile/indexstorageface.h>

class TMemoryPortionUsage;

namespace NRTYServer {
    class IIndexer {
    public:
        virtual ~IIndexer() {}
        virtual void Start() = 0;
        virtual void IndexDoc(const TParsedDocument& document) = 0;
        virtual void IncDoc(ui32 docId) = 0;
        virtual void Stop() = 0;
        virtual void RegisterStorageAttr(IYndexStorage* storage) = 0;
        virtual void RegisterStorageLemm(IYndexStorage* storage) = 0;
        virtual void RegisterInvCreator(NIndexerCore::IDirectTextCallback4* callback) = 0;
        virtual void RegisterDTCallback(NIndexerCore::IDirectTextCallback2* callback) = 0;
    };
}

class TRTYIndexer: public NIndexerCore::TDocumentProcessor::IEventsProcessor, public NRTYServer::IIndexer {
public:
    TRTYIndexer(const TDirConf& config, const TBaseConfig& baseConfig, int prefix, const TRTYServerConfig& ownerConfig, const TExternalIndexers& externalIndexers);
    ~TRTYIndexer();
    void Start() override;
    void Stop() override;
    void IncDoc(ui32 docId) override;
    void IndexDoc(const TParsedDocument& document) override;
    virtual void RegisterStorageAttr(IYndexStorage* storage) override;
    virtual void RegisterStorageLemm(IYndexStorage* storage) override;
    virtual void RegisterInvCreator(NIndexerCore::IDirectTextCallback4* callback) override;
    virtual void RegisterDTCallback(NIndexerCore::IDirectTextCallback2* callback) override;
private:
    void BuildIndexedDoc(const TIndexParsedEntity& docIndex);
    void StoreIndexedDoc(const TIndexParsedEntity& docIndex);
private:
    void BuildExtAttrs(const TDocInfoEx& docInfo, TFullDocAttrs& docAttrs) const;

private:
    const TRTYServerConfig& RTYConfig;
    const TExternalIndexers ExternalIndexers;
    TBaseConfig BaseConfig;
    TString Directory;
    TString Prefix;
    ui32 Thread;

    TVector<ui32> DocIds;
    TVector<IYndexStorage*> StoragesAttr;
    TVector<IYndexStorage*> StoragesLemm;
    TVector<NIndexerCore::IDirectTextCallback4*> InvCreators;
    TVector<NIndexerCore::IDirectTextCallback2*> DTCallbacks;
    TVector<TAtomicSharedPtr<NIndexerCore::IDirectTextCallback2>> NGrammsCallbacks;
    ui32 Counter;
    ui32 NumPortion;
    ui32 MaxPortionDocs;

    THolder<TFixedBufferFileOutput> PlsAdFile, PlsFile;
    THolder<TMemoryPortionUsage> MemoryPortionAttr;
    THolder<TMemoryPortionUsage> MemoryPortionBody;
    THolder<TGroupProcessor> GroupProcessor;
    TAttrProcessorConfig AttrProcessorConfig;
    THolder<TIndexedDocStorage> IndexedDocStorage;
    THolder<TIndexedDocStorageConfig> IndexedDocStorageConfig;
    TRTYParsedDocStorage* ParsedDocStorage;

    bool IsWorking;

    TBuffer PositionsBuffer;
    TBuffer ReadBuffer;
};
