#include "sent_normalizer.h"

#include <kernel/walrus/sentlen.h>

namespace {
    const TString SentFile = "indexsent";
}

TSentenceLengthsNormalizer::TSentenceLengthsNormalizer(const TRTYServerConfig& config, bool requiredSentLens)
    : NRTYServer::INormalizer(config)
    , RequiredSentLens(requiredSentLens)
{}

const char* TSentenceLengthsNormalizer::Name() const {
    return "SentenceLengths";
}

bool TSentenceLengthsNormalizer::AllRight(const NRTYServer::TNormalizerContext& context, const THolder<TFileMap>& /*indexFrq*/) const {
    return RequiredSentLens == NFs::Exists(context.Dir.PathName() + "/" + SentFile);
}

void TSentenceLengthsNormalizer::Fix(const NRTYServer::TNormalizerContext& context, const THolder<TFileMap>& /*indexFrq*/) const {
    if (!RequiredSentLens) {
        NFs::Remove(context.Dir.PathName() + "/" + SentFile);
        NFs::Remove(context.Dir.PathName() + "/" + SentFile + ".title");
        return;
    }

    TSentLens lens;

    const TString& invIndex = context.Dir.PathName() + "/index";
    const TString& indexsent = context.Dir.PathName() + "/" + SentFile;

    NIndexerCore::TIndexReader reader(invIndex.data(), IYndexStorage::FINAL_FORMAT);
    while (reader.ReadKey()) {
        const char* key = reader.GetKeyText();
        lens.SetKey(key);

        TPosIterator<> pos;
        for (reader.InitPosIterator(pos); pos.Valid(); pos.Next()) {
            lens.AddHit(pos.Current());
        }
    }

    lens.Save(indexsent.data());
}
