#include "tf_normalizer.h"

#include <saas/util/logging/exception_process.h>

#include <util/system/fs.h>

TIndexTfNormalizer::TIndexTfNormalizer(const TRTYServerConfig& config)
    : NRTYServer::INormalizer(config)
{}

const char* TIndexTfNormalizer::Name() const {
    return "indextf";
}

bool TIndexTfNormalizer::AllRight(const NRTYServer::TNormalizerContext& context, const THolder<TFileMap>& /*indexFrq*/) const {
    return !TFsPath(context.Dir.PathName() + "/indextf").Exists();
}

void TIndexTfNormalizer::Fix(const NRTYServer::TNormalizerContext& context, const THolder<TFileMap>& /*indexFrq*/) const {
    TRY
        NFs::Remove(context.Dir.PathName() + "/indextf");
        return;
    CATCH("On RepairIndexTf");
    VERIFY_WITH_LOG(false, "Incorrect normalization: RepairIndexTf")
}
