#pragma once

#include "const.h"
#include "config.h"

#include <saas/rtyserver_jupi/library/rtyt/config.pb.h>

#include <saas/rtyserver/indexer_core/abstract_model.h>
#include <saas/rtyserver/indexer_core/normalizer.h>
#include <saas/rtyserver/model/external_builder.h>

namespace NRTYServer {
class TJupiComponent : public NRTYServer::IIndexComponent {
protected:
    TIndexFiles IndexFiles; // empty
    const TRTYServerConfig& Config;
    const TJupiComponentConfig& ComponentConfig;
    NFusion::TRTYTBuilderConfig RTYTConfig;

protected:
    mutable IExtBuilderClient::TPtr ExtBuilder;
    THolder<INormalizer> Normalizer;

public:
    static NFusion::TRTYTBuilderConfig GetDefaultRTYTConfig();

    TJupiComponent(const TRTYServerConfig& config);

    virtual void CheckAndFix(const TNormalizerContext& context) const override;

    virtual TString GetName() const override;

public:
    virtual bool CheckAlways() const override {
        return true;
    }

protected:
    virtual bool DoMerge(const TMergeContext& context) const override;
    virtual bool DoAllRight(const TNormalizerContext& context) const override;

public:
    virtual const IIndexFilesGroup::TIndexFiles& GetIndexFiles() const override;
    virtual THolder<IIndexComponentBuilder> CreateBuilder(const TBuilderConstructionContext& context) const override;
    virtual THolder<IIndexComponentManager> CreateManager(const TManagerConstructionContext& context) const override;
    virtual IComponentParser::TPtr BuildParser() const override;
    virtual IParsedEntity::TPtr BuildParsedEntity(IParsedEntity::TConstructParams& params) const override;

private:
    static TFactory::TRegistrator<TJupiComponent> Registrator;
};

}
