#include "config.h"

#include <library/cpp/yconf/conf.h>

bool TJupiComponentConfig::DoCheck() const {
    return true;
}

void TJupiComponentConfig::DoInit(const TYandexConfig::Section& componentSection) {
    auto children = componentSection.GetAllChildren();
    if (children.contains("RTYT")) {
        const auto& rtytSection = children.find("RTYT")->second;
        const auto& directives = rtytSection->GetDirectives();
        RtytEnabled = directives.Value<bool>("Enabled", false);
        TimerLogPath = directives.Value<TString>("TimerLogPath", "");
        if (TimerLogPath->GetName().Empty()) {
            TimerLogPath = Nothing();
        }
        VerifyIndexesRegex = directives.Value<TString>("VerifyIndexesRegex", "");
        if (VerifyIndexesRegex->Empty()) {
            VerifyIndexesRegex = Nothing();
        }

        RtytBuilderConfigPath = directives.Value<TString>("BuilderConfigPath", "");
        if (RtytBuilderConfigPath->GetName().Empty()) {
            RtytBuilderConfigPath = Nothing();
        }
        CrashOnDiff = directives.Value<bool>("CrashOnDiff", false);
    } else {
        RtytEnabled = false;
        TimerLogPath = Nothing();
        VerifyIndexesRegex = Nothing();
        CrashOnDiff = false;
    }
}

void TJupiComponentConfig::DoToString(IOutputStream& so) const {
    so << "<RTYT>" << Endl;
    so << "Enabled : " << RtytEnabled << Endl;
    if (TimerLogPath.Defined()) {
        so << "TimerLogPath : " << TimerLogPath.GetRef() << Endl;
    }
    if (VerifyIndexesRegex.Defined()) {
        so << "VerifyIndexesRegex : " << VerifyIndexesRegex.GetRef() << Endl;
    }
    if (RtytBuilderConfigPath.Defined()) {
        so << "BuilderConfigPath : " << RtytBuilderConfigPath->GetPath() << Endl;
    }
    so << "CrashOnDiff : " << CrashOnDiff << Endl;
    so << "</RTYT>" << Endl;
}
