#pragma once

#include <saas/library/daemon_base/module/module.h>
#include <saas/rtyserver/config/config.h>

class TJupiComponentConfig: public TPluginConfig<TRTYServerConfig::IComponentConfig> {
private:
    bool RtytEnabled = false;
    TMaybe<TFsPath> TimerLogPath;
    TMaybe<TFsPath> RtytBuilderConfigPath;
    TMaybe<TString> VerifyIndexesRegex;
    bool CrashOnDiff = false;

protected:
    virtual bool DoCheck() const;
    virtual void DoInit(const TYandexConfig::Section& componentSection);
    virtual void DoToString(IOutputStream& so) const;

public:

    bool GetRtytEnabled() const {
        return RtytEnabled;
    }
    
    const TMaybe<TFsPath>& GetTimerLogPath() const {
        return TimerLogPath;
    }

    const TMaybe<TString>& GetVerifyIndexesRegex() const {
        return VerifyIndexesRegex;
    }

    const TMaybe<TFsPath>& GetRtytBuilderConfigPath() const {
        return RtytBuilderConfigPath;
    }

    bool GetCrashOnDiff() const {
        return CrashOnDiff;
    }
};
