#pragma once

#include "const.h"

#include <saas/rtyserver/indexer_core/abstract_model.h>
#include <util/system/yassert.h>

namespace NRTYServer {
class TJupiComponentManager
    : public NRTYServer::IIndexComponentManager
{
    THashSet<ui32> DeletedDocids;
public:

    TJupiComponentManager()
        : NRTYServer::IIndexComponentManager(JupiComponentName)
    {
    }

    const THashSet<ui32>& GetDeletedDocids() const {
        return DeletedDocids;
    }
    // NRTYServer::IIndexComponentManager
    virtual bool GetDocInfo(const ui32 /*docId*/, NJson::TJsonValue& /*result*/) const override {
        return true;
    }
    virtual ui32 GetDocumentsCount() const override {
        return Max<ui32>();
    }

    virtual void InitInteractions(const NRTYServer::IIndexManagersStorage& /* storage */) override {
    }

    virtual bool UpdateDoc(ui32 /*docId*/, const TParsedDocument::TPtr /*doc*/) override {
        return false;
    }

    virtual ui32 RemoveDocids(const TVector<ui32>& docids) override {
        DeletedDocids.insert(docids.begin(), docids.end());
        return 0;
    }

    virtual bool DoOpen() override {
        return true;
    }

    virtual bool DoClose() override {
        return true;
    }
};

}

