#include "const.h"
#include "parsed_entity.h"

#include <robot/jupiter/library/rtdoc/protos/lumps.pb.h>
#include <yweb/protos/indexeddoc.pb.h>
#include <dict/dictutil/str.h>

namespace NRTYServer {
void TJupiDocParser::Parse(TParsingContext& context) const {
    auto* result = context.Result.GetComponentEntity<TJupiParsedEntity>(JupiComponentName);
    VERIFY_WITH_LOG(result, "TJupiParsedEntity is missing");

    if (Y_UNLIKELY(!context.Document.HasIndexedDoc()))
        return;

    const NRealTime::TIndexedDoc& idoc = context.Document.GetIndexedDoc();

    NJupiter::TMercuryLumps* resData = result->MutableData();
    Y_ASSERT(resData);

    for (ui32 i = 0; i < idoc.WadLumpsSize(); i++) {
        const NRealTime::TIndexedDoc::TMapType& srcLump = idoc.GetWadLumps(i);
        NJupiter::TMapType* lump = resData->AddLumps();
        lump->SetName(srcLump.GetName());
        lump->SetData(srcLump.GetData());
    }
}
}
