#include "l2_builder.h"

#include "l2_normalizer.h"

#include <saas/rtyserver/model/builder.h>

namespace NRTYServer {
    void TL2ComponentBuilder::InitInteractions(const NRTYServer::IIndexBuildersStorage& builders) {
        // TL2ComponentBuilder does not need FullArc, however we have to ensure that the FullArc component exists.
        const auto* fa = builders.GetBuilder<IIndexComponentBuilder>(FULL_ARCHIVE_COMPONENT_NAME);
        CHECK_WITH_LOG(fa);
    }

    bool TL2ComponentBuilder::DoWriteMeta(NRTYServer::TIndexMetadata& metadata) const {
        ui32 head = Core->GetNormalizerVersion();
        TL2Normalizer::SetNormalizerVersion(metadata, EntityName, head);
        return true;
    }

    bool TL2ComponentBuilder::DoClose(const TBuilderCloseContext&) {
        return true;
    }
}
