#pragma once

#include "l2_core.h"

#include <saas/rtyserver/model/builder.h>

namespace NRTYServer {
    class TL2ComponentBuilder: public IIndexComponentBuilder {
    private:
        IIndexComponentManager* Manager;
        IL2ComponentCore::TPtr Core;
        TString EntityName;

    public:
        TL2ComponentBuilder(const TString& componentName, const TString& entityName, IIndexComponentManager* manager, IL2ComponentCore::TPtr core)
            : IIndexComponentBuilder(componentName)
            , Manager(manager)
            , Core(core)
            , EntityName(entityName)
        {
        }

        virtual bool Start() override {
            return true;
        }

        virtual bool Stop() override {
            return true;
        }

        virtual IIndexComponentManager* GetManager() override {
            return Manager;
        }

        virtual void Index(int /*threadId*/, const TParsedDocument& /*doc*/, const ui32 /*docId*/) override {
            // We do nothing in the common case (fullarchive does the job)
            // Overload this method in case you need to build some aggregates
        }

        virtual void InitInteractions(const NRTYServer::IIndexBuildersStorage& builders) override;

    protected:
        virtual bool DoWriteMeta(NRTYServer::TIndexMetadata& metadata) const override;

        virtual bool DoClose(const TBuilderCloseContext&) override;
    };
}
