#pragma once

#include <saas/rtyserver/components/fullarchive/light_layers_registry.h>
#include <saas/rtyserver/config/config.h>

// Just a small helper to ensure that everything is registered with the same name
namespace NRTYServer {
    template <typename TComponent, typename TConfig>
    class TL2ComponentsRegistrator {
        NRTYServer::IIndexComponent::TFactory::TRegistrator<TComponent> Registrator;
        TRTYServerConfig::IComponentConfig::TFactory::TRegistrator<TConfig> ConfigRegistrator;
        TLightLayersRegistry::TRegistrator FullArcLightLayerRegistrator;

    public:
        TL2ComponentsRegistrator(TStringBuf componentName)
            : Registrator((TString)componentName)
            , ConfigRegistrator((TString)componentName)
            , FullArcLightLayerRegistrator(componentName)
        {
        }
    };
}
