#include "l2_config.h"

#include <library/cpp/yconf/conf.h>

namespace {
    static const TString l2LayerName("L2");
}

namespace NRTYServer {
    TL2ComponentConfig::TL2ComponentConfig()
        : LayerName(l2LayerName)
    {
    }

    void TL2ComponentConfig::DoInit(const TYandexConfig::Section& componentSection) {
        Enabled = componentSection.GetDirectives().Value<bool>("Enabled", true);
        LayerName = componentSection.GetDirectives().Value<TString>("LayerName", l2LayerName);
    }

    bool TL2ComponentConfig::DoCheck() const {
        if (!Enabled)
            return true;

        return !LayerName.empty();
    }

    void TL2ComponentConfig::DoToString(IOutputStream& so) const {
        so << "LayerName : " << LayerName << Endl;
        so << "Enabled : " << Enabled << Endl;
    }

    //
    // TL2DocStorageParams
    //
    TL2DocStorageParams::TL2DocStorageParams(const TString& layer, const TString& entityName)
        : Layer(layer)
        , PropertyName(entityName)
    {
    }
}
