#pragma once

#include <saas/library/daemon_base/module/module.h>
#include <saas/rtyserver/config/config.h>

namespace NRTYServer {
    class TL2ComponentConfig: public TPluginConfig<TRTYServerConfig::IComponentConfig> {
    private:
        bool Enabled;
        TString LayerName;

    protected:
        virtual bool DoCheck() const;
        virtual void DoInit(const TYandexConfig::Section& componentSection);
        virtual void DoToString(IOutputStream& so) const;

    public:
        TL2ComponentConfig();

        bool GetEnabled() const {
            return Enabled;
        }

        TString GetLayerName() const {
            return LayerName;
        }
    };

    //
    // TL2DocStorageParams: where to store in fullarc
    // Should be removed after migtation
    //
    class TL2DocStorageParams {
    private:
        TString Layer;
        TString PropertyName;

    public:
        TL2DocStorageParams(const TString& layer, const TString& entityName);

        inline const TString& GetLayer() const {
            return Layer;
        }

        inline const TString& GetPropertyName() const {
            return PropertyName;
        }
    };
}
