#pragma once

#include <saas/rtyserver/indexer_core/abstract_model.h>

struct TRTYServerConfig;

namespace NRTYServer {
    class TL2ComponentMemoryManagerBase;
    class IL2ComponentCore: public TThrRefBase {
    public:
        using TPtr = TIntrusivePtr<IL2ComponentCore>;

        // using TDiskManager = (defined in the descendant)
        // using TMemoryManager = (defined in the descendant)
        // using TParser = (defined in the descendant)
        // using TDocEntity = (defined in the descendant)
        using TMemoryManager = TL2ComponentMemoryManagerBase; // Default value, might be overridden in the descendant
    public:
        virtual TStringBuf GetName() const = 0;

        ui32 GetNormalizerVersion() const {
            // if the version in index is less than that, IL2ComponentCore::Normalize() will be called for each document record (not implemented yet)
            return 0;
        }

        virtual bool SupportsMemorySearch() const {
            return false;
        }

        virtual void Init(const TRTYServerConfig&) {
        }
    };
}
