#include "l2_disk_manager.h"

#include "saas/rtyserver/components/fullarchive/disk_manager.h"

namespace NRTYServer {
    void TL2ComponentDiskManagerBase::InitInteractions(const NRTYServer::IIndexManagersStorage& storage) {
        // We do not use IFAManager abstraction here, because everyone else does the same
        // ( https://cs.yandex-team.ru/#!GetManager%3CTDiskFAManager%3E,%5Esaas,jC,arcadia,,5000 )
        //FIXME: [refactor] publish the used methods from FullArchive into IFAManager interface

        FullArc = storage.GetManager<TDiskFAManager>(FULL_ARCHIVE_COMPONENT_NAME);
        CHECK_WITH_LOG(FullArc);
    }

    TBlob TL2ComponentDiskManagerBase::FetchRawL2Data(ui32 docId) const {
        Y_ASSERT(FullArc && GetComponentName());
        auto res = FullArc->ReadRawDoc(GetComponentName(), docId);
        return res;
    }
}
