#pragma once

#include "l2_config.h"
#include "l2_core.h"
#include "l2_manager.h"

#include <saas/rtyserver/indexer_core/abstract_model.h>

#include <util/system/yassert.h>

class TDiskFAManager;

namespace NRTYServer {
    class IL2RawAccessor {
    public:
        virtual ~IL2RawAccessor() = default;

        virtual TBlob FetchRaw(ui32 docId) const = 0;
    };

    class TL2ComponentDiskManagerBase: public TL2ComponentManagerBase, protected IL2RawAccessor {
    public:
        TL2ComponentDiskManagerBase(const TString& componentName, const TL2DocStorageParams& params, IL2ComponentCore::TPtr core)
            : TL2ComponentManagerBase(componentName, core)
            , StorageParams(params)
            , FullArc(nullptr)
        {
        }

        TL2ComponentDiskManagerBase(const TString& componentName, const TString& /*indexDir*/, const TL2DocStorageParams& params, IL2ComponentCore::TPtr core)
            : TL2ComponentDiskManagerBase(componentName, params, core)
        {
        }


        void InitInteractions(const NRTYServer::IIndexManagersStorage& storage) override;

    protected:
        TBlob FetchRawL2Data(ui32 docId) const;

        TBlob FetchRaw(ui32 docId) const override {
            // A public accessor for IndexData-like classes
            return FetchRawL2Data(docId);
        }

    protected:
        TL2DocStorageParams StorageParams;
        const TDiskFAManager* FullArc = nullptr;

    private:
        IL2ComponentCore::TPtr Core;
    };
}
