#pragma once

#include "l2_config.h"
#include "l2_core.h"

#include <saas/rtyserver/indexer_core/abstract_model.h>

#include <util/system/yassert.h>

namespace NRTYServer {
    class TL2ComponentManagerBase: public NRTYServer::IIndexComponentManager {
    public:
        TL2ComponentManagerBase(const TString& componentName, IL2ComponentCore::TPtr core)
            : NRTYServer::IIndexComponentManager(componentName)
            , Core(core)
        {
        }

    public:
        //
        // interface NRTYServer::IIndexComponentManager
        //
        bool GetDocInfo(const ui32 /*docId*/, NJson::TJsonValue& /*result*/) const override {
            return true;
        }

        ui32 GetDocumentsCount() const override {
            // components (other than the main index component) are allowed to return ~0u here.
            return Max<ui32>();
        }

        bool UpdateDoc(ui32 /*docId*/, const TParsedDocument::TPtr /*doc*/) override {
            // The IParsedEntity is responsible for calling NeedInRestore for any update that includes L2 data.
            // Hence any update with L2 data is a SlowUpdate and UpdateDoc() is not used.
            return false;
        }

        ui32 RemoveDocids(const TVector<ui32>& /*docids*/) override {
            // components (other than the main index component) are allowed to do nothing here.
            return 0;
        }

        bool DoOpen() override {
            return true;
        }

        bool DoClose() override {
            return true;
        }

    protected:
        IL2ComponentCore* GetCore() const {
            return Core.Get();
        }

    private:
        IL2ComponentCore::TPtr Core;
    };
}
