#include "l2_memory_manager.h"

#include "saas/rtyserver/components/fullarchive/memory_manager.h"

namespace NRTYServer {
    void TL2ComponentMemoryManagerBase::InitInteractions(const NRTYServer::IIndexManagersStorage& storage) {
        // We do not use IFAManager abstraction here, because everyone else does the same
        // ( https://cs.yandex-team.ru/#!GetManager%3CTDiskFAManager%3E,%5Esaas,jC,arcadia,,5000 )
        //FIXME: [refactor] publish the used methods from FullArchive into IFAManager interface

        FullArc = storage.GetManager<TMemoryFAManager>(FULL_ARCHIVE_COMPONENT_NAME);
        CHECK_WITH_LOG(FullArc);
    }

    TParsedDocument::TPtr TL2ComponentMemoryManagerBase::GetParsedDocument(ui32 docId) const {
        return FullArc->GetDoc(docId);
    }
}
